import re
import os
import sys
import math
import random
import matplotlib.pyplot as plt
import json
from os import rename
from os.path import basename
from pprint import pprint


file_in = open('mlb_batting.csv', 'r')

xcoord = {}
ycoord = {}
zcoord = {}
batting_avg = {}
doubles = {}
triples = {}
home_runs = {}
rbi = {}
player_data = {}
inc = 0
for line in file_in:
    print(str(inc) + " " + line)
    line_array = line.split(",")
    xcoord[inc] = line_array[0]
    ycoord[inc] = line_array[1]
    zcoord[inc] = line_array[2]
    batting_avg[inc] = line_array[3]
    doubles[inc] = line_array[4]
    triples[inc] = line_array[5]
    home_runs[inc] = line_array[6]
    rbi[inc] = line_array[7]
    player_data[inc] = line_array[8].strip()
    inc += 1
total_players = inc


# Initialize all ANTz Node variables
id = 0
type = 5
data = id
selected = 0
parent_id = 0
branch_level = 0
child_id = id
child_index = 0
child_count = 0
ch_input_id = 0
ch_output_id = 0
ch_last_updated = 0
average = 0
interval = 1
aux_a_x = 0
aux_a_y = 0
aux_a_z = 0
aux_b_x = 0
aux_b_y = 0
aux_b_z = 0
color_shift = 0
rotate_vec_x = 0
rotate_vec_y = 0
rotate_vec_z = 0
rotate_vec_s = 1
scale_x = 0
scale_y = 0
scale_z = 0
translate_x = 0
translate_y = 0
translate_z = 0
tag_offset_x = 0
tag_offset_y = 0
tag_offset_z = 0
rotate_rate_x = 0
rotate_rate_y = 0
rotate_rate_z = 0
rotate_x = 0
rotate_y = 0
rotate_z = 0
scale_rate_x = 0
scale_rate_y = 0
scale_rate_z = 0
translate_rate_x = 0
translate_rate_y = 0
translate_rate_z = 0
translate_vec_x = 0
translate_vec_y = 0
translate_vec_z = 0
shader = 0
geometry = 3
line_width = 1
point_size = 0
ratio = 0.1
color_index = 0
color_r = 110
color_g = 110
color_b = 110
color_a = 255
color_fade = 0
texture_id = 0
hide = 0
freeze = 0
topo = 2
facet = 0
auto_zoom_x = 0
auto_zoom_y = 0
auto_zoom_z = 0
trigger_hi_x = 0
trigger_hi_y = 0
trigger_hi_z = 0
trigger_lo_x = 0
trigger_lo_y = 0
trigger_lo_z = 1
set_hi_x = 0
set_hi_y = 0
set_hi_z = 0
set_lo_x = 0
set_lo_y = 0
set_lo_z = 0
proximity_x = 0
proximity_y = 0
proximity_z = 0
proximity_mode_x = 0
proximity_mode_y = 0
proximity_mode_z = 0
segments_x = 16
segments_y = 16
segments_z = 0
tag_mode = 0
format_id = 0
table_id = 0
record_id = id
size = 420


# Open ANTz Node file for writing
fout = open("usr/csv/antz0001node.csv","w")

# Open the Tag file to add metadata to ANTz objects
ftag = open("usr/csv/antz0001tag.csv","w")
# Write the header string
outputstring = "id,record_id,table_id,title,description\n"
ftag.write(outputstring)

# Write rows for header, world, camera views (4), and grid to Node file
outputstring = "id,type,data,selected,parent_id,branch_level,child_id,child_index,child_count,ch_input_id,ch_output_id,ch_last_updated,average,interval,aux_a_x,aux_a_y,aux_a_z,aux_b_x,aux_b_y,aux_b_z,color_shift,rotate_vec_x,rotate_vec_y,rotate_vec_z,rotate_vec_s,scale_x,scale_y,scale_z,translate_x,translate_y,translate_z,tag_offset_x,tag_offset_y,tag_offset_z,rotate_rate_x,rotate_rate_y,rotate_rate_z,rotate_x,rotate_y,rotate_z,scale_rate_x,scale_rate_y,scale_rate_z,translate_rate_x,translate_rate_y,translate_rate_z,translate_vec_x,translate_vec_y,translate_vec_z,shader,geometry,line_width,point_size,ratio,color_index,color_r,color_g,color_b,color_a,color_fade,texture_id,hide,freeze,topo,facet,auto_zoom_x,auto_zoom_y,auto_zoom_z,trigger_hi_x,trigger_hi_y,trigger_hi_z,trigger_lo_x,trigger_lo_y,trigger_lo_z,set_hi_x,set_hi_y,set_hi_z,set_lo_x,set_lo_y,set_lo_z,proximity_x,proximity_y,proximity_z,proximity_mode_x,proximity_mode_y,proximity_mode_z,segments_x,segments_y,segments_z,tag_mode,format_id,table_id,record_id,size\n"
fout.write(outputstring)

# Row for world parameters
outputstring = "1,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n"
fout.write(outputstring)
# Row for first camera view
outputstring = "2,1,2,0,0,0,2,2,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0.008645,0.825266,-0.564678,1,1,1,-32.446629,-180.908295,143.514175,0,0,1,0,0,0,55.620094,0.600200,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214.306686,0,0,0,0,0,16,16,0,0,0,0,0,420\n"
fout.write(outputstring)
# Row for second camera view
outputstring = "3,1,3,0,2,1,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1,1,1,1,-0.500000,0,571.750000,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n"
fout.write(outputstring)
# Third camera view
outputstring = "4,1,4,0,2,1,4,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,-0,1,1,1,0,-90,7,0,0,1,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n"
fout.write(outputstring)
# Fourth camera view
outputstring = "5,1,5,0,2,1,5,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1,-0,-0,1,1,1,85,0,7,0,0,1,0,0,0,90,270,0,0,0,0,0,0,0,-0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n"
fout.write(outputstring)
# Default Grid
outputstring = "6,6,6,1,0,0,0,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,3,0,0,255,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,12,6,0,0,0,0,0,420\n"
fout.write(outputstring)

# Initialize increments
taginc = 0
id = 6

numlevel0toroids = total_players
numlevel1toroids = 4
numlevel2toroids = 0

i = 0
# Loop Through Tweets of Most Common Users and Output to ANTz Node and Tag Files
while i < numlevel0toroids:
    pprint("i:" + str(i))
    # Modify relevant ANTz parameters
    id += 1
    data = id
    type = 5
    parent_id = 0
    selected = 0
    branch_level = 0
    child_id = id
    child_count = numlevel1toroids
    translate_x = xcoord[i]
    translate_y = ycoord[i]
    translate_z = zcoord[i]
    scale_x = 2.0 * float(batting_avg[i])
    scale_y = scale_x
    scale_z = scale_x
    geometry = 1
    topo = 7

    # Determine if root object should be green for tweet or red for retweet
    color_index = 1
    color_r = 100
    color_g = 100
    color_b = 100
    record_id = id
    # Creat output string and write to ANTz Node File
    outputstring = str(id) + "," + str(type) + "," + str(data) + "," + str(selected) + "," + str(parent_id) + "," + str(branch_level) + "," + str(child_id) + "," + str(child_index) + "," + str(child_count) + "," + str(ch_input_id) + "," + str(ch_output_id) + "," + str(ch_last_updated) + "," + str(average) + "," + str(interval) + "," + str(aux_a_x) + "," + str(aux_a_y) + "," + str(aux_a_z) + "," + str(aux_b_x) + "," + str(aux_b_y) + "," + str(aux_b_z) + "," + str(color_shift) + "," + str(rotate_vec_x) + "," + str(rotate_vec_y) + "," + str(rotate_vec_z) + "," + str(rotate_vec_s) + "," + str(scale_x) + "," + str(scale_y) + "," + str(scale_z) + "," + str(translate_x) + "," + str(translate_y) + "," + str(translate_z) + "," + str(tag_offset_x) + "," + str(tag_offset_y) + "," + str(tag_offset_z) + "," + str(rotate_rate_x) + "," + str(rotate_rate_y) + "," + str(rotate_rate_z) + "," + str(rotate_x) + "," + str(rotate_y) + "," + str(rotate_z) + "," + str(scale_rate_x) + "," + str(scale_rate_y) + "," + str(scale_rate_z) + "," + str(translate_rate_x) + "," + str(translate_rate_y) + "," + str(translate_rate_z) + "," + str(translate_vec_x) + "," + str(translate_vec_y) + "," + str(translate_vec_z) + "," + str(shader) + "," + str(geometry) + "," + str(line_width) + "," + str(point_size) + "," + str(ratio) + "," + str(color_index) + "," + str(color_r) + "," + str(color_g) + "," + str(color_b) + "," + str(color_a) + "," + str(color_fade) + "," + str(texture_id) + "," + str(hide) + "," + str(freeze) + "," + str(topo) + "," + str(facet) + "," + str(auto_zoom_x) + "," + str(auto_zoom_y) + "," + str(auto_zoom_z) + "," + str(trigger_hi_x) + "," + str(trigger_hi_y) + "," + str(trigger_hi_z) + "," + str(trigger_lo_x) + "," + str(trigger_lo_y) + "," + str(trigger_lo_z) + "," + str(set_hi_x) + "," + str(set_hi_y) + "," + str(set_hi_z) + "," + str(set_lo_x) + "," + str(set_lo_y) + "," + str(set_lo_z) + "," + str(proximity_x) + "," + str(proximity_y) + "," + str(proximity_z) + "," + str(proximity_mode_x) + "," + str(proximity_mode_y) + "," + str(proximity_mode_z) + "," + str(segments_x) + "," + str(segments_y) + "," + str(segments_z) + "," + str(tag_mode) + "," + str(format_id) + "," + str(table_id) + "," + str(record_id) + "," + str(size) + "\n"
    fout.write(outputstring)

    # Output to Tag file
    tagtext = player_data[i] + " Batting Avg." + batting_avg[i]
    tagstring = str(taginc) + "," + str(record_id) + ",0,\"" + tagtext + "\",\"\"\n"
    ftag.write(tagstring)
    taginc += 1

    # Get id for parent object of branch level 1 objects created below
    level0objectid = id

    # Branch level 1 includes a single rod geometry with 
    # scale_z proportional to followers count since Sept. 1, 2017
    # Colored cyan for increase in followers_count, white for decrease
    j = 0
    while j < numlevel1toroids:
        id += 1
        data = id
        type = 5
        parent_id = level0objectid
        selected = 0
        branch_level = 1
        child_id = id
        child_count = numlevel2toroids
        translate_x = j * 360/numlevel1toroids
        translate_y = 0
        translate_z = 2
        if j == 0:
            scale_x = float(doubles[i])/40
            color_index = 3
            color_r = 0
            color_g = 255
            color_b = 255
            tagtext = "Doubles:" + doubles[i]
        elif j == 1:
            scale_x = float(triples[i])/20
            color_index = 4
            color_r = 255
            color_g = 0
            color_b = 255
            tagtext = "Triples:" + triples[i]
        elif j == 2:
            scale_x = float(home_runs[i])/20
            color_index = 5
            color_r = 255
            color_g = 255
            color_b = 0
            tagtext = "Home Runs:" + home_runs[i]
        else:
            scale_x = float(rbi[i])/100
            color_index = 6
            color_r = 255
            color_g = 125
            color_b = 0
            tagtext = "RBIs:" + rbi[i]
        
        scale_y = scale_x
        scale_z = scale_x
        geometry = 1
        topo = 7
        record_id = id
        outputstring = str(id) + "," + str(type) + "," + str(data) + "," + str(selected) + "," + str(parent_id) + "," + str(branch_level) + "," + str(child_id) + "," + str(child_index) + "," + str(child_count) + "," + str(ch_input_id) + "," + str(ch_output_id) + "," + str(ch_last_updated) + "," + str(average) + "," + str(interval) + "," + str(aux_a_x) + "," + str(aux_a_y) + "," + str(aux_a_z) + "," + str(aux_b_x) + "," + str(aux_b_y) + "," + str(aux_b_z) + "," + str(color_shift) + "," + str(rotate_vec_x) + "," + str(rotate_vec_y) + "," + str(rotate_vec_z) + "," + str(rotate_vec_s) + "," + str(scale_x) + "," + str(scale_y) + "," + str(scale_z) + "," + str(translate_x) + "," + str(translate_y) + "," + str(translate_z) + "," + str(tag_offset_x) + "," + str(tag_offset_y) + "," + str(tag_offset_z) + "," + str(rotate_rate_x) + "," + str(rotate_rate_y) + "," + str(rotate_rate_z) + "," + str(rotate_x) + "," + str(rotate_y) + "," + str(rotate_z) + "," + str(scale_rate_x) + "," + str(scale_rate_y) + "," + str(scale_rate_z) + "," + str(translate_rate_x) + "," + str(translate_rate_y) + "," + str(translate_rate_z) + "," + str(translate_vec_x) + "," + str(translate_vec_y) + "," + str(translate_vec_z) + "," + str(shader) + "," + str(geometry) + "," + str(line_width) + "," + str(point_size) + "," + str(ratio) + "," + str(color_index) + "," + str(color_r) + "," + str(color_g) + "," + str(color_b) + "," + str(color_a) + "," + str(color_fade) + "," + str(texture_id) + "," + str(hide) + "," + str(freeze) + "," + str(topo) + "," + str(facet) + "," + str(auto_zoom_x) + "," + str(auto_zoom_y) + "," + str(auto_zoom_z) + "," + str(trigger_hi_x) + "," + str(trigger_hi_y) + "," + str(trigger_hi_z) + "," + str(trigger_lo_x) + "," + str(trigger_lo_y) + "," + str(trigger_lo_z) + "," + str(set_hi_x) + "," + str(set_hi_y) + "," + str(set_hi_z) + "," + str(set_lo_x) + "," + str(set_lo_y) + "," + str(set_lo_z) + "," + str(proximity_x) + "," + str(proximity_y) + "," + str(proximity_z) + "," + str(proximity_mode_x) + "," + str(proximity_mode_y) + "," + str(proximity_mode_z) + "," + str(segments_x) + "," + str(segments_y) + "," + str(segments_z) + "," + str(tag_mode) + "," + str(format_id) + "," + str(table_id) + "," + str(record_id) + "," + str(size) + "\n"
        fout.write(outputstring)

        ## Output to Tag file
        tagstring = str(taginc) + "," + str(record_id) + ",0,\"" + tagtext + "\",\"\"\n"
        ftag.write(tagstring)
        taginc += 1
        level1objectid = id
        
        j += 1
    i += 1


fout.close()
ftag.close()

