#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define NUM_COLORS (10)
#define XMAX (2000)

char** str_split(char* a_str, const char a_delim)
{
    	char** result    = 0;
    	size_t count     = 0;
    	char* tmp        = a_str;
    	char* last_comma = 0;
    	char delim[2];
    	delim[0] = a_delim;
    	delim[1] = 0;
    
    	/* Count how many elements will be extracted. */
    	while (*tmp)
    	{   
        	if (a_delim == *tmp)
        	{   
            		count++;
            		last_comma = tmp;
        	}
        	tmp++;
    	}
    
    	/* Add space for trailing token. */
    	count += last_comma < (a_str + strlen(a_str) - 1);
    
    	/* Add space for terminating null string so caller
       	knows where the list of returned strings ends. */
    	count++;
    
    	result = malloc(sizeof(char*) * count);
    
    	if (result)
    	{
        	size_t idx  = 0;
        	char* token = strtok(a_str, delim);
        
        	while (token)
        	{   
            		assert(idx < count);
            		*(result + idx++) = strdup(token);
            		token = strtok(0, delim);
        	}
        	assert(idx == count - 1);
        	*(result + idx) = 0;
    	}
    
    	return result;
}


int main(void) {

	FILE *finptr;
	FILE *foutptr;
	FILE *ftagptr;

	char buff[255];
    	char** tokens;
	float xcoord[20000];
	float ycoord[20000];
	float zcoord[20000];
	float batting_avg[20000];
	float rbi[20000];
	float home_runs[20000];
	float doubles[20000];
	float triples[20000];
	char* player_team_year[20000];
        int level0objectid, level1objectid, level2objectid;
	int i, j, k;

	finptr = fopen("mlb_batting.csv", "r");
	int inc = 0;
	while (!feof(finptr))
	{
		fscanf(finptr, "%s", buff);
		//printf("%d : %s\n", inc, buff );
		tokens = str_split(buff, ',');
		xcoord[inc] = atof(*(tokens + 0));
		ycoord[inc] = atof(*(tokens + 1));
		zcoord[inc] = atof(*(tokens + 2));
		batting_avg[inc] = atof(*(tokens + 3));
		doubles[inc] = atof(*(tokens + 4));
		triples[inc] = atof(*(tokens + 5));
		home_runs[inc] = atof(*(tokens + 6));
		rbi[inc] = atof(*(tokens + 7));
		player_team_year[inc] = tokens[8];
		printf("%d--%s--%s--%s--%s--%s--%s--%s--%s--%s--\n", inc, *(tokens + 0), *(tokens + 1), *(tokens + 2), *(tokens + 3), *(tokens + 4), *(tokens + 5), *(tokens + 6), *(tokens + 7), player_team_year[inc]);
		inc++;
	}

	fclose(finptr);
	int total_players = inc;
	//for (i = 0; i < total_players; i++) {
		//printf("%d %s\n", i, player_team_year[i]);
	//}
	foutptr = fopen("usr/csv/antz0001node.csv", "w");
	ftagptr = fopen("usr/csv/antz0001tag.csv", "w");

        // My basic color palette
        int color_r_array[NUM_COLORS] = {255,0,0,0,255,255,255,100,150,0};
        int color_g_array[NUM_COLORS] = {0,255,0,255,0,255,153,0,150,100};
        int color_b_array[NUM_COLORS] = {0,0,255,255,255,0,0,50,150,50};

        // Set Initial Conditions for all parameters
        int id = 0;
        int type = 5;
        int data = id;
        int selected = 0;
        int parent_id = 0;
        int branch_level = 0;
        int child_id = id;
        int child_index = 0;
        int child_count = 0;
        int ch_input_id = 0;
        int ch_output_id = 0;
        int ch_last_updated = 0;
        int average = 0;
        int interval = 1;
        int aux_a_x = 0;
        int aux_a_y = 0;
        int aux_a_z = 0;
        int aux_b_x = 0;
        int aux_b_y = 0;
        int aux_b_z = 0;
        int color_shift = 0;
        float rotate_vec_x = 0;
        float rotate_vec_y = 0;
        float rotate_vec_z = 0;
        float rotate_vec_s = 1;
        float scale_x = 0;
        float scale_y = 0;
        float scale_z = 0;
        float translate_x = 0;
        float translate_y = 0;
        float translate_z = 0;
        float tag_offset_x = 0;
        float tag_offset_y = 0;
        float tag_offset_z = 0;
        float rotate_rate_x = 0;
        float rotate_rate_y = 0;
        float rotate_rate_z = 0;
        float rotate_x = 0;
        float rotate_y = 0;
        float rotate_z = 0;
        float scale_rate_x = 0;
        float scale_rate_y = 0;
        float scale_rate_z = 0;
        float translate_rate_x = 0;
        float translate_rate_y = 0;
        float translate_rate_z = 0;
        float translate_vec_x = 0;
        float translate_vec_y = 0;
        float translate_vec_z = 0;
        int shader = 0;
        int geometry = 3;
        int line_width = 1;
        int point_size = 0;
        float ratio = 0.1;
        int color_index = 0;
        int color_r = 110;
        int color_g = 110;
        int color_b = 110;
        int color_a = 255;
        int color_fade = 0;
        int texture_id = 0;
        int hide = 0;
        int freeze = 0;
        int topo = 2;
        int facet = 0;
        int auto_zoom_x = 0;
        int auto_zoom_y = 0;
        int auto_zoom_z = 0;
        int trigger_hi_x = 0;
        int trigger_hi_y = 0;
        int trigger_hi_z = 0;
        int trigger_lo_x = 0;
        int trigger_lo_y = 0;
        int trigger_lo_z = 1;
        int set_hi_x = 0;
        int set_hi_y = 0;
        int set_hi_z = 0;
        int set_lo_x = 0;
        int set_lo_y = 0;
        int set_lo_z = 0;
        int proximity_x = 0;
        int proximity_y = 0;
        int proximity_z = 0;
        int proximity_mode_x = 0;
        int proximity_mode_y = 0;
        int proximity_mode_z = 0;
        int segments_x = 16;
        int segments_y = 16;
        int segments_z = 0;
        int tag_mode = 0;
        int format_id = 0;
        int table_id = 0;
        int record_id = id;
        int size = 420;

        int numlevel0toroids = total_players;
        int numlevel1toroids = 4;
        int numlevel2toroids = 0;
        int numlevel3toroids = 0;
	int parent_id_array[2000];

        if((foutptr = fopen("usr/csv/antz0001node.csv", "w")) == NULL) {
                printf("Cannot open output file\n");
        }
        if((ftagptr = fopen("usr/csv/antz0001tag.csv", "w")) == NULL) {
                printf("Cannot open tag file\n");
        }

        fprintf(ftagptr, "id,record_id,table_id,title,description\n");

        //Output initial lines of ANTz code for world, cameras, and grid(s)
        fprintf(foutptr, "id,type,data,selected,parent_id,branch_level,child_id,child_index,child_count,ch_input_id,ch_output_id,ch_last_updated,average,interval,aux_a_x,aux_a_y,aux_a_z,aux_b_x,aux_b_y,aux_b_z,color_shift,rotate_vec_x,rotate_vec_y,rotate_vec_z,rotate_vec_s,scale_x,scale_y,scale_z,translate_x,translate_y,translate_z,tag_offset_x,tag_offset_y,tag_offset_z,rotate_rate_x,rotate_rate_y,rotate_rate_z,rotate_x,rotate_y,rotate_z,scale_rate_x,scale_rate_y,scale_rate_z,translate_rate_x,translate_rate_y,translate_rate_z,translate_vec_x,translate_vec_y,translate_vec_z,shader,geometry,line_width,point_size,ratio,color_index,color_r,color_g,color_b,color_a,color_fade,texture_id,hide,freeze,topo,facet,auto_zoom_x,auto_zoom_y,auto_zoom_z,trigger_hi_x,trigger_hi_y,trigger_hi_z,trigger_lo_x,trigger_lo_y,trigger_lo_z,set_hi_x,set_hi_y,set_hi_z,set_lo_x,set_lo_y,set_lo_z,proximity_x,proximity_y,proximity_z,proximity_mode_x,proximity_mode_y,proximity_mode_z,segments_x,segments_y,segments_z,tag_mode,format_id,table_id,record_id,size\n");
        fprintf(foutptr, "1,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
        fprintf(foutptr, "2,1,2,0,0,0,2,2,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0.008645,0.825266,-0.564678,1,1,1,-32.446629,-180.908295,143.514175,0,0,1,0,0,0,55.620094,0.600200,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214.306686,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
        fprintf(foutptr, "3,1,3,0,2,1,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1,1,1,1,-0.5,0,571.750000,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
        fprintf(foutptr, "4,1,4,0,2,1,4,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,-0,1,1,1,0,-90,7,0,0,1,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
        fprintf(foutptr, "5,1,5,0,2,1,5,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1,-0,-0,1,1,1,85,0,7,0,0,1,0,0,0,90,270,0,0,0,0,0,0,0,-0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
        fprintf(foutptr, "6,6,6,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,1.0,0.0,0.1,3,0,0,255,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,0,12,6,0,0,0,0,0,420\n");

        id = 6;
	int taginc = 0;

        // Loop through Branch Level 0 (BL0) objects
        for (i = 0; i < numlevel0toroids; i++) {
                id++;
                parent_id_array[i] = id; // Save the id to be used for Links Loop below
                type = 5;
                data = id;
                parent_id = 0;
                branch_level = 0;
                child_id = id;
                child_count = numlevel1toroids;
                translate_x = 1.0*xcoord[i];
                translate_y = 1.0*ycoord[i];
                translate_z = 1.0*zcoord[i];
		//printf("%10.5f %10.5f %10.5f\n", translate_x, translate_y, translate_z);
                scale_x = 1.0*batting_avg[i];
                scale_y = scale_x;
                scale_z = scale_x;
                color_index = 8;
		color_r = 100;
		color_g = 100;
		color_b = 100;
                geometry = 1;
                topo = 7;  // A topo of 5 is the usual default for BL 0
                record_id = id;
                        fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r,color_g,color_b, color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
                fprintf(ftagptr, "%d,%d,0,\"%s AVG:%4.3f\",\"\"\n", taginc, id, player_team_year[i], batting_avg[i]);
                taginc++;

                level0objectid = id; // used for parent_id of child objects

                // Loop through BL1 objects
                for (j = 0; j < numlevel1toroids; j++) {
                        id++;
                        type = 5;
                        data = id;
                        parent_id = level0objectid;
                        branch_level = 1;
                        child_id = id;
                        child_count = numlevel2toroids;
                        translate_y = 0;
                        translate_z = 2;
                        record_id = id;
			if (j == 0) {
				translate_x = 180;
				scale_x = doubles[i]/40;
				color_index = 3;
				color_r = 0;
				color_g = 255;
				color_b = 255;
				int doubles_value = doubles[i];
                		fprintf(ftagptr, "%d,%d,0,\"Doubles: %d\",\"\"\n", taginc,record_id,doubles_value);
			} else if (j == 1) {
				translate_x = 270;
				scale_x = triples[i]/20;
				color_index = 4;
				color_r = 255;
				color_g = 0;
				color_b = 255;
				int triples_value = triples[i];
                		fprintf(ftagptr, "%d,%d,0,\"Triples: %d\",\"\"\n", taginc,record_id,triples_value);
			} else if (j == 2) {
				translate_x = 90;
				scale_x = home_runs[i]/20;
				color_index = 5;
				color_r = 255;
				color_g = 255;
				color_b = 0;
				int home_runs_value = home_runs[i];
                		fprintf(ftagptr, "%d,%d,0,\"Home Runs: %d\",\"\"\n", taginc,record_id,home_runs_value);
			} else if (j == 3) {
				translate_x = 0;
				scale_x = rbi[i]/100;
				color_index = 6;
				color_r = 255;
				color_g = 128;
				color_b = 0;
				int rbi_value = rbi[i];
                		fprintf(ftagptr, "%d,%d,0,\"RBI: %d\",\"\"\n", taginc,record_id,rbi_value);
			}
                        scale_y = scale_x;
                        scale_z = scale_x;
                        geometry = 1;
                        topo = 7;  // A topo of 5 is the usual default for BL 0
                        fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r,color_g,color_b, color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
                	taginc++;
                        level1objectid = id; // used for parent_id of child objects

		}
	}
	fclose(foutptr);
	fclose(ftagptr);

	return 0;
}
