/** ----------------------------------------------------------------------
*
*  main.c
*
*  ANTz - realtime 3D data visualization tools for the real-world, based on NPE.
*
*  Hosted at http://openantz.com and NPE at http://neuralphysics.org
*
*  Written in 2010-2017 by Shane Saxon - saxon@openantz.com
*
*  Additional code contributors are listed chronologically: Lucas Erickson,
*  Mark Buchanan and Johannes Johannsen
*
*  Special thanks to Dave Warner, project synergist and conceptual architect.
*  Additional gratitude to Jeff Sale for creating great data visualizations.
*
*  To the extent possible under law, the author(s) have dedicated all copyright
*  and related and neighboring rights to this software to the public domain
*  worldwide. This software is distributed without any warranty.
*
*  Released under the CC0 license, which is GPL compatible.
*
*  You should have received a copy of the CC0 Public Domain Dedication along
*  with this software (license file named LICENSE.txt). If not, see
*  http://creativecommons.org/publicdomain/zero/1.0/
*
* --------------------------------------------------------------------------- */

//! Using Doxygen with graphviz DOT for inline code docs.
#include "npdata.h"					/// Our data map is a scene graph.
#include "npio.h"					/// IO for all user devices, file, DB, net.
#include "npctrl.h"					/// Control logic with physics.

/*!
 @param argc command line argument count
 @param argv tokenized arguments: load files, set parameters. 
		Get help, run 'antz ?' to see a list of command line arguments.
 @return 0 if exited normally, otherwise returns an error number which is 
		generated by the OS application framework.
*/
int main (int argc, char **argv)
{
/*! --------------------------------------------------------------------------
*  MVC architecture variant where View becomes a subset of the IO group.
*  Model named Data (map) is a global Scene Graph.
*  View named IO, includes keyboard, mice, haptic devices, audio, video...
*  Control named Ctrl, an event driven pseudo state-machine based on physics.
*
*  Ctrl modifies the scene state and the Neural Physics Engine updates it.
*  Platform specific functions are separately placed in the 'os' subfolders.
*
*  Currently only a single (global) dataRef instance is used, but expect that
*  multiple instances will be created to support several users and GL contexts.
*
*  CPU load is currently 15% NPE, 5% qsort, 80% GL commands.
*  Greatest performance gain would be to make the GL code run in parallel.
*  main() can be compiled as either C or C++
* --------------------------------------------------------------------------- */

	int err = 0;
	void* data = NULL;

	data = npInitData (argc, argv);			/// Model named - map
	npInitIO (data);						/// View called - io
	npInitCtrl (data);						/// Control -> ctrl

	err = npAppLoop (data);					/// enter main app loop

	npCloseCtrl (data);						/// halt ctrl
	npCloseIO (data);						/// release io
	npCloseData (data);						/// destroy map

	return err;
}

