<?php

// Initialize
ini_set('memory_limit', '2048M');
ini_set('max_execution_time', 600);

$datevar = date('d_m_y_h_i_s');  // I use this in the prefix if I want to keep all the files I create
$timevar = date('h_i_s');  // I use this in the prefix for daily development

// Set debug flags to be used mainly for outputting info to the browser.
$DEBUG = false;
$DEBUG2 = false;
$DEBUG3 = false;
$DEBUG4 = false;

// Set Initial Conditions for all parameters
// It is probably better to store these values in an include file
$id = 0;
$type = 5;
$data = $id;
$selected = 0;
$parent_id = 0;
$branch_level = 0;
$child_id = $id;
$child_index = 0;
$child_count = 0;
$ch_input_id = 0;
$ch_output_id = 0;
$ch_last_updated = 0;
$average = 0;
$sample = 1;
$interval = 1;
$aux_a_x = 0;
$aux_a_y = 0;
$aux_a_z = 0;
$aux_b_x = 0;
$aux_b_y = 0;
$aux_b_z = 0;
$color_shift = 0;
$rotate_vec_x = 0;
$rotate_vec_y = 0;
$rotate_vec_z = 0;
$rotate_vec_s = 1;
$scale_x = 0;
$scale_y = 0;
$scale_z = 0;
$translate_x = 0;
$translate_y = 0;
$translate_z = 0;
$tag_offset_x = 0;
$tag_offset_y = 0;
$tag_offset_z = 0;
$rotate_rate_x = 0;
$rotate_rate_y = 0;
$rotate_rate_z = 0;
$rotate_x = 0;
$rotate_y = 0;
$rotate_z = 0;
$scale_rate_x = 0;
$scale_rate_y = 0;
$scale_rate_z = 0;
$translate_rate_x = 0;
$translate_rate_y = 0;
$translate_rate_z = 0;
$translate_vec_x = 0;
$translate_vec_y = 0;
$translate_vec_z = 0;
$shader = 0;
$geometry = 3;
$line_width = 1;
$point_size = 0;
$ratio = 0.1;
$color_index = 0;
$color_r = 110;
$color_g = 110;
$color_b = 110;
$color_a = 255;
$color_fade = 0;
$texture_id = 0;
$hide = 0;
$freeze = 0;
$topo = 2;
$facet = 0;
$auto_zoom_x = 0;
$auto_zoom_y = 0;
$auto_zoom_z = 0;
$trigger_hi_x = 0;
$trigger_hi_y = 0;
$trigger_hi_z = 0;
$trigger_lo_x = 0;
$trigger_lo_y = 0;
$trigger_lo_z = 1;
$set_hi_x = 0;
$set_hi_y = 0;
$set_hi_z = 0;
$set_lo_x = 0;
$set_lo_y = 0;
$set_lo_z = 0;
$proximity_x = 0;
$proximity_y = 0;
$proximity_z = 0;
$proximity_mode_x = 0;
$proximity_mode_y = 0;
$proximity_mode_z = 0;
$segments_x = 16;
$segments_y = 16;
$segments_z = 0;
$tag_mode = 0;
$format_id = 0;
$table_id = 0;
$record_id = $id;
$size = 420;

// My basic color palette
$colortable[0] = "255,0,0"; //red
$colortable[1] = "0,255,0"; //green
$colortable[2] = "0,0,255"; //blue
$colortable[3] = "0,255,255"; //cyan
$colortable[4] = "255,0,255"; //magenta
$colortable[5] = "255,255,0"; //yellow
$colortable[6] = "255,153,0"; //orange
$colortable[7] = "255,0,102"; //hot pink
$colortable[8] = "0,255,102"; //dark cyan
$colortable[9] = "0,155,0";  //dark green
$colortable[10] = "128,0,128"; //deep purple
$colortable[11] = "0,180,180"; //turquoise
$colortable[12] = "204,102,0"; //brown
$colortable[13] = "153,0,0"; //deep red
$colortable[14] = "0,115,115";  //dark turquoise
$colortable[15] = "0,225,225";  // med cyan
$colortable[16] = "190,190,190";  //light gray
$colortable[17] = "255,255,255";  //white
$colortable[18] = "100,100,255";  //light blue
$colortable[19] = "255,180,255";  //light purple
$colortable[20] = "255,200,0";  //gold
$colortable[21] = "0,100,120";  //
$colortable[22] = "40,100,180"; //
$colortable[23] = "80,100,220"; //
$colortable[24] = "100,255,100";  //light green
$colortable[25] = "100,100,100";  //dark gray
$colortable[26] = "127,127,127";  //medium gray
$colortable[27] = "34,89,222";  //
$colortable[28] = "222,89,34";  //
$colortable[29] = "66,199,0";  //
$colortable[30] = "45,160,0";  //
$colortable[31] = "100,50,50";  //
$colortable[32] = "0,0,0";  //black

//////////////////////////////////////////////////////////////////////////////////////////////
// Open Antz CSV Node file for writing.
// This is the main file used with Antz. It contains the essential data, 
// but does not contain tags (labels),
// or channel data.
//////////////////////////////////////////////////////////////////////////////////////////////

$outputfile = "usr/csv/antz0001node.csv"; 
@$fpout1 = fopen($outputfile, 'w');

if (!$fpout1) {
	echo "<p><strong>Antz CSV output file $outputfile cannot be opened for writing.</strong></p>";
	exit;
}

//////////////////////////////////////////////////////////////////////////////////////////////
// Open Antz Tag file for writing label info.
//////////////////////////////////////////////////////////////////////////////////////////////

$tagfile = "usr/csv/antz0001tag.csv";
@$fptag1 = fopen($tagfile, 'w');

if (!$fptag1) {
	echo "<p><strong>Antz Tag file $tagfile cannot be opened for writing.</strong></p>";
	exit;
}

// Write the  first line to the tag file
$tagstring = "id,record_id,table_id,title,description\n";  // Header row
fwrite($fptag1, $tagstring);  // Write the header row to the Tag file


//Output initial lines of ANTz code for world, cameras, and grid(s)
$outputstring = "id,type,data,selected,parent_id,branch_level,child_id,child_index,child_count,ch_input_id,ch_output_id,ch_last_updated,average,interval,aux_a_x,aux_a_y,aux_a_z,aux_b_x,aux_b_y,aux_b_z,color_shift,rotate_vec_x,rotate_vec_y,rotate_vec_z,rotate_vec_s,scale_x,scale_y,scale_z,translate_x,translate_y,translate_z,tag_offset_x,tag_offset_y,tag_offset_z,rotate_rate_x,rotate_rate_y,rotate_rate_z,rotate_x,rotate_y,rotate_z,scale_rate_x,scale_rate_y,scale_rate_z,translate_rate_x,translate_rate_y,translate_rate_z,translate_vec_x,translate_vec_y,translate_vec_z,shader,geometry,line_width,point_size,ratio,color_index,color_r,color_g,color_b,color_a,color_fade,texture_id,hide,freeze,topo,facet,auto_zoom_x,auto_zoom_y,auto_zoom_z,trigger_hi_x,trigger_hi_y,trigger_hi_z,trigger_lo_x,trigger_lo_y,trigger_lo_z,set_hi_x,set_hi_y,set_hi_z,set_lo_x,set_lo_y,set_lo_z,proximity_x,proximity_y,proximity_z,proximity_mode_x,proximity_mode_y,proximity_mode_z,segments_x,segments_y,segments_z,tag_mode,format_id,table_id,record_id,size\n";
fwrite($fpout1, $outputstring);
$outputstring = "1,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);
$outputstring = "2,1,2,0,0,0,2,2,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0.008645,0.825266,-0.564678,1,1,1,-32.446629,-180.908295,143.514175,0,0,1,0,0,0,55.620094,0.600200,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214.306686,0,0,0,0,0,16,16,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);
$outputstring = "3,1,3,0,2,1,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1,1,1,1,-0.5,0,571.750000,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);
$outputstring = "4,1,4,0,2,1,4,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,-0,1,1,1,0,-90,7,0,0,1,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);
$outputstring = "5,1,5,0,2,1,5,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1,-0,-0,1,1,1,85,0,7,0,0,1,0,0,0,90,270,0,0,0,0,0,0,0,-0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);
$outputstring = "6,6,6,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,1.0,0.0,0.1,3,0,0,255,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,0,12,6,0,0,0,0,0,420\n";
fwrite($fpout1, $outputstring);

// Set initial values for branch level object counts
// numlevel0toroids is specified in the loop below
$numlevel0toroids = 10;
$numlevel1toroids = 1;
$numlevel2toroids = 10;
$numlevel3toroids = 5;
$numlevel4toroids = 0;

$id = 6;
$start_id = $id;
$taginc = 0;

////////////////////////////////////////////////////////////////////////
// We loop through BL 0
////////////////////////////////////////////////////////////////////////
for ($i = 0; $i < $numlevel0toroids; $i++) {
	$id++;
	$parent_id_array[$i] = $id; // Save id to array for Links Loop below
	$type = 5;
	$data = $id;
	$parent_id = 0;
	$branch_level = 0;
	$child_id = $id;
	$child_count = 1;
	$translate_x = rand(0,100);
	$translate_y = rand(0,100);
	$translate_z = rand(0,100);
	$scale_x = 2.0;
	$scale_y = $scale_x;
	$scale_z = $scale_x;
	$color_index = 17;
	$colorvar = $colortable[$color_index];
	$geometry = 16;
	$topo = 5;  // A topo of 5 is the usual default for BL 0
	$record_id = $id;
	$outputstring = "$id, $type, $data, $selected, $parent_id, $branch_level, $child_id, $child_index, $child_count, $ch_input_id, $ch_output_id, $ch_last_updated, $average, $interval, $aux_a_x, $aux_a_y, $aux_a_z, $aux_b_x, $aux_b_y, $aux_b_z, $color_shift, $rotate_vec_x, $rotate_vec_y, $rotate_vec_z, $rotate_vec_s, $scale_x, $scale_y, $scale_z, $translate_x, $translate_y, $translate_z, $tag_offset_x, $tag_offset_y, $tag_offset_z, $rotate_rate_x, $rotate_rate_y, $rotate_rate_z, $rotate_x, $rotate_y, $rotate_z, $scale_rate_x, $scale_rate_y, $scale_rate_z, $translate_rate_x, $translate_rate_y, $translate_rate_z, $translate_vec_x, $translate_vec_y, $translate_vec_z, $shader, $geometry, $line_width, $point_size, $ratio, $color_index, $colorvar, $color_a, $color_fade, $texture_id, $hide, $freeze, $topo, $facet, $auto_zoom_x, $auto_zoom_y, $auto_zoom_z, $trigger_hi_x, $trigger_hi_y, $trigger_hi_z, $trigger_lo_x, $trigger_lo_y, $trigger_lo_z, $set_hi_x, $set_hi_y, $set_hi_z, $set_lo_x, $set_lo_y, $set_lo_z, $proximity_x, $proximity_y, $proximity_z, $proximity_mode_x, $proximity_mode_y, $proximity_mode_z, $segments_x, $segments_y, $segments_z, $tag_mode, $format_id, $table_id, $record_id, $size\n";
	if ($DEBUG) echo $outputstring."<br />\n";
	fwrite($fpout1, $outputstring);
	
	$tagtext = "id:$id BL0";
	$tagstring = "$taginc,$record_id,0,\"$tagtext\",\"\"\n";
	$taginc++;
	fwrite($fptag1, $tagstring);
	$level0objectid = $id; // used for parent_id of child objects

	////////////////////////////////////////////////////////////////////////
	// We loop through Branch Level 1 (BL1)
	////////////////////////////////////////////////////////////////////////
	for ($j = 0; $j < $numlevel1toroids; $j++) {  
		$id++;
		$data = $id;
		$parent_id = $level0objectid;
		$branch_level = 1; 
		$child_id = $id;
		$child_count = $numlevel2toroids;
		$scale_x = 1.0;
		$scale_y = $scale_x;
		$scale_z = $scale_x;
		$translate_x = $j*360/$numlevel1toroids;
		$translate_y = 0;
		$translate_z = 0;
		$color_index = 1;
		$colorvar = $colortable[$color_index];
		$color_a = 255; // Not needed since 255 is the default, but try making it smaller
		$geometry = 7;  // A toroid is the usual default BL 1 object
		$ratio = 0.1;  // Makes for a skinnier looking toroid, 0.1 is the default
		$topo = 3;  // A topo of 3 is the usual defautl for BL 21. This is the value you can change with the J key, too.
		$record_id = $id;  
		$outputstring = "$id, $type, $data, $selected, $parent_id, $branch_level, $child_id, $child_index, $child_count, $ch_input_id, $ch_output_id, $ch_last_updated, $average, $interval, $aux_a_x, $aux_a_y, $aux_a_z, $aux_b_x, $aux_b_y, $aux_b_z, $color_shift, $rotate_vec_x, $rotate_vec_y, $rotate_vec_z, $rotate_vec_s, $scale_x, $scale_y, $scale_z, $translate_x, $translate_y, $translate_z, $tag_offset_x, $tag_offset_y, $tag_offset_z, $rotate_rate_x, $rotate_rate_y, $rotate_rate_z, $rotate_x, $rotate_y, $rotate_z, $scale_rate_x, $scale_rate_y, $scale_rate_z, $translate_rate_x, $translate_rate_y, $translate_rate_z, $translate_vec_x, $translate_vec_y, $translate_vec_z, $shader, $geometry, $line_width, $point_size, $ratio, $color_index, $colorvar, $color_a, $color_fade, $texture_id, $hide, $freeze, $topo, $facet, $auto_zoom_x, $auto_zoom_y, $auto_zoom_z, $trigger_hi_x, $trigger_hi_y, $trigger_hi_z, $trigger_lo_x, $trigger_lo_y, $trigger_lo_z, $set_hi_x, $set_hi_y, $set_hi_z, $set_lo_x, $set_lo_y, $set_lo_z, $proximity_x, $proximity_y, $proximity_z, $proximity_mode_x, $proximity_mode_y, $proximity_mode_z, $segments_x, $segments_y, $segments_z, $tag_mode, $format_id, $table_id, $record_id, $size\n";
		if ($DEBUG2) echo $outputstring."<br />\n";
		fwrite($fpout1, $outputstring);
		$tagtext = "i: ".$i." j: ".$j;
		$tagstring = "$taginc,$record_id,0,\"$tagtext\",\"\"\n";
		$taginc++;
		fwrite($fptag1, $tagstring);
		$level1objectid = $id;
		
		////////////////////////////////////////////////////////////////////////
		// We loop through BL 2
		////////////////////////////////////////////////////////////////////////
		for ($k = 0; $k < $numlevel2toroids; $k++) {  
			$id++;
			$data = $id;
			$parent_id = $level1objectid;
			$child_id = $id;
			$child_count = $numlevel3toroids;
			$branch_level = 2;
			$translate_x = $k*360/$numlevel2toroids;
			$translate_y = 0;
			$translate_z = 180;
			$scale_x = 0.5;
			$scale_y = $scale_x;
			$scale_z = $scale_x;
			$color_index = 2;
			$colorvar = $colortable[$color_index];
			$color_a = 255;
			$geometry = 7;
			$ratio = 0.1;
			$topo = 3;
			$record_id = $id;
			$outputstring = "$id, $type, $data, $selected, $parent_id, $branch_level, $child_id, $child_index, $child_count, $ch_input_id, $ch_output_id, $ch_last_updated, $average, $interval, $aux_a_x, $aux_a_y, $aux_a_z, $aux_b_x, $aux_b_y, $aux_b_z, $color_shift, $rotate_vec_x, $rotate_vec_y, $rotate_vec_z, $rotate_vec_s, $scale_x, $scale_y, $scale_z, $translate_x, $translate_y, $translate_z, $tag_offset_x, $tag_offset_y, $tag_offset_z, $rotate_rate_x, $rotate_rate_y, $rotate_rate_z, $rotate_x, $rotate_y, $rotate_z, $scale_rate_x, $scale_rate_y, $scale_rate_z, $translate_rate_x, $translate_rate_y, $translate_rate_z, $translate_vec_x, $translate_vec_y, $translate_vec_z, $shader, $geometry, $line_width, $point_size, $ratio, $color_index, $colorvar, $color_a, $color_fade, $texture_id, $hide, $freeze, $topo, $facet, $auto_zoom_x, $auto_zoom_y, $auto_zoom_z, $trigger_hi_x, $trigger_hi_y, $trigger_hi_z, $trigger_lo_x, $trigger_lo_y, $trigger_lo_z, $set_hi_x, $set_hi_y, $set_hi_z, $set_lo_x, $set_lo_y, $set_lo_z, $proximity_x, $proximity_y, $proximity_z, $proximity_mode_x, $proximity_mode_y, $proximity_mode_z, $segments_x, $segments_y, $segments_z, $tag_mode, $format_id, $table_id, $record_id, $size\n";
			if ($DEBUG3) echo $outputstring."<br />\n";
			fwrite($fpout1, $outputstring);
			$tagtext = "i:$i j:$j k:$k";
			$tagstring = "$taginc,$record_id,0,\"$tagtext\",\"\"\n";
			fwrite($fptag1, $tagstring);
			$taginc++;
			$level2objectid = $id;
			
			////////////////////////////////////////////////////////////////////////
			// We loop through BL 3
			////////////////////////////////////////////////////////////////////////
			for ($l = 0; $l < $numlevel3toroids; $l++) {  
				$id++;
				$data = $id;
				$parent_id = $level2objectid;
				$child_id = $id;
				$child_count = $numlevel4toroids;
				$branch_level = 3;
				$translate_x = $l*360/$numlevel3toroids;
				$translate_y = 0;
				$translate_z = 180;
				$scale_x = 0.5;
				$scale_y = $scale_x;
				$scale_z = $scale_x;
				$color_index = 3;
				$colorvar = $colortable[$color_index];
				$color_a = 255;
				$geometry = 7;
				$ratio = 0.1;
				$topo = 3;
				$record_id = $id;
				$outputstring = "$id, $type, $data, $selected, $parent_id, $branch_level, $child_id, $child_index, $child_count, $ch_input_id, $ch_output_id, $ch_last_updated, $average, $interval, $aux_a_x, $aux_a_y, $aux_a_z, $aux_b_x, $aux_b_y, $aux_b_z, $color_shift, $rotate_vec_x, $rotate_vec_y, $rotate_vec_z, $rotate_vec_s, $scale_x, $scale_y, $scale_z, $translate_x, $translate_y, $translate_z, $tag_offset_x, $tag_offset_y, $tag_offset_z, $rotate_rate_x, $rotate_rate_y, $rotate_rate_z, $rotate_x, $rotate_y, $rotate_z, $scale_rate_x, $scale_rate_y, $scale_rate_z, $translate_rate_x, $translate_rate_y, $translate_rate_z, $translate_vec_x, $translate_vec_y, $translate_vec_z, $shader, $geometry, $line_width, $point_size, $ratio, $color_index, $colorvar, $color_a, $color_fade, $texture_id, $hide, $freeze, $topo, $facet, $auto_zoom_x, $auto_zoom_y, $auto_zoom_z, $trigger_hi_x, $trigger_hi_y, $trigger_hi_z, $trigger_lo_x, $trigger_lo_y, $trigger_lo_z, $set_hi_x, $set_hi_y, $set_hi_z, $set_lo_x, $set_lo_y, $set_lo_z, $proximity_x, $proximity_y, $proximity_z, $proximity_mode_x, $proximity_mode_y, $proximity_mode_z, $segments_x, $segments_y, $segments_z, $tag_mode, $format_id, $table_id, $record_id, $size\n";
				if ($DEBUG4) echo $outputstring."<br />\n";
				fwrite($fpout1, $outputstring);
				$tagtext = "i:$i j:$j k:$k l:$l";
				if ($DEBUG) echo "tagtext = $tagtext<br />";
				$tagstring = "$taginc,$record_id,0,\"$tagtext\",\"\"\n";
				fwrite($fptag1, $tagstring);
				$taginc++;
				$level3objectid = $id;
			} // end for l
		} // end for k
	} // end for j
} // end for i


//////////////////////////////////////////////////////////////////////////
// Links Loop
// We loop through total objects twice and create links between each pair
//////////////////////////////////////////////////////////////////////////
for ($i = 0; $i < $numlevel0toroids; $i++) {
	for ($j = 0; $j < $numlevel0toroids; $j++) {
		if ($i != $j) {
			$id++;
			$type = 7;
			$data = $id;
			$parent_id = $parent_id_array[$i];
			$branch_level = 1;
			$child_id = $parent_id_array[$j];
			$child_count = 1;
			$translate_x = 0;
			$translate_y = 0;
			$translate_z = 0;
			$scale_x = 1;
			$scale_y = $scale_x;
			$scale_z = $scale_x;
			$rotate_x = 0;
			$rotate_y = 0;
			$rotate_z = 0;
			$color_index = 0;
			$colorvar = $colortable[$color_index];
			$geometry = 19;
			$topo = 0; 
			$record_id = $id;
			$ratio = 0.25;
			$outputstring = "$id, $type, $data, $selected, $parent_id, $branch_level, $child_id, $child_index, $child_count, $ch_input_id, $ch_output_id, $ch_last_updated, $average, $interval, $aux_a_x, $aux_a_y, $aux_a_z, $aux_b_x, $aux_b_y, $aux_b_z, $color_shift, $rotate_vec_x, $rotate_vec_y, $rotate_vec_z, $rotate_vec_s, $scale_x, $scale_y, $scale_z, $translate_x, $translate_y, $translate_z, $tag_offset_x, $tag_offset_y, $tag_offset_z, $rotate_rate_x, $rotate_rate_y, $rotate_rate_z, $rotate_x, $rotate_y, $rotate_z, $scale_rate_x, $scale_rate_y, $scale_rate_z, $translate_rate_x, $translate_rate_y, $translate_rate_z, $translate_vec_x, $translate_vec_y, $translate_vec_z, $shader, $geometry, $line_width, $point_size, $ratio, $color_index, $colorvar, $color_a, $color_fade, $texture_id, $hide, $freeze, $topo, $facet, $auto_zoom_x, $auto_zoom_y, $auto_zoom_z, $trigger_hi_x, $trigger_hi_y, $trigger_hi_z, $trigger_lo_x, $trigger_lo_y, $trigger_lo_z, $set_hi_x, $set_hi_y, $set_hi_z, $set_lo_x, $set_lo_y, $set_lo_z, $proximity_x, $proximity_y, $proximity_z, $proximity_mode_x, $proximity_mode_y, $proximity_mode_z, $segments_x, $segments_y, $segments_z, $tag_mode, $format_id, $table_id, $record_id, $size\n";
			if ($DEBUG2) echo $outputstring."<br />\n";
			fwrite($fpout1, $outputstring);
			
			$tagtext = "id:$id BL1 Link parent_id:".$parent_id_array[$i]." child_id:".$parent_id_array[$i];
			$tagstring = "$taginc,$record_id,0,\"$tagtext\",\"\"\n";
			fwrite($fptag1, $tagstring);
			$taginc++;
		}
	}
}

fclose($fpout1);
fclose($fptag1);
$total_objects_created = $id - $start_id;
echo "Total objects created: $total_objects_created<br /><br />";

?>
