#define XMAX 	(700)
#define YMAX	(17)
#define NUM_COLORS	(10)
#define NUM_CHARS (1024)
#define NUMLEVEL0TOROIDS (10)

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stdbool.h>

int main(void) {

	FILE * foutptr;
	FILE * ftagptr;
    
    int i, j, k;
	int level0objectid, level1objectid, level2objectid;
    float a1[XMAX][YMAX];
	int parent_id_array[NUMLEVEL0TOROIDS];
	
	// My basic color palette
	int color_r_array[NUM_COLORS] = {255,0,0,0,255,255,255,100,50,0};
	int color_g_array[NUM_COLORS] = {0,255,0,255,0,255,153,0,50,100};
	int color_b_array[NUM_COLORS] = {0,0,255,255,255,0,0,50,50,50};

	// Set debug flags to be used mainly for outputting info to the browser.
	bool DEBUG = false;

	// Set Initial Conditions for all parameters
	int id = 0;
	int type = 5;
	int data = id;
	int selected = 0;
	int parent_id = 0;
	int branch_level = 0;
	int child_id = id;
	int child_index = 0;
	int child_count = 0;
	int ch_input_id = 0;
	int ch_output_id = 0;
	int ch_last_updated = 0;
	int average = 0;
	int interval = 1;
	int aux_a_x = 0;
	int aux_a_y = 0;
	int aux_a_z = 0;
	int aux_b_x = 0;
	int aux_b_y = 0;
	int aux_b_z = 0;
	int color_shift = 0;
	float rotate_vec_x = 0;
	float rotate_vec_y = 0;
	float rotate_vec_z = 0;
	float rotate_vec_s = 1;
	float scale_x = 0;
	float scale_y = 0;
	float scale_z = 0;
	float translate_x = 0;
	float translate_y = 0;
	float translate_z = 0;
	float tag_offset_x = 0;
	float tag_offset_y = 0;
	float tag_offset_z = 0;
	float rotate_rate_x = 0;
	float rotate_rate_y = 0;
	float rotate_rate_z = 0;
	float rotate_x = 0;
	float rotate_y = 0;
	float rotate_z = 0;
	float scale_rate_x = 0;
	float scale_rate_y = 0;
	float scale_rate_z = 0;
	float translate_rate_x = 0;
	float translate_rate_y = 0;
	float translate_rate_z = 0;
	float translate_vec_x = 0;
	float translate_vec_y = 0;
	float translate_vec_z = 0;
	int shader = 0;
	int geometry = 3;
	int line_width = 1;
	int point_size = 0;
	float ratio = 0.1;
	int color_index = 0;
	int color_r = 110;
	int color_g = 110;
	int color_b = 110;
	int color_a = 255;
	int color_fade = 0;
	int texture_id = 0;
	int hide = 0;
	int freeze = 0;
	int topo = 2;
	int facet = 0;
	int auto_zoom_x = 0;
	int auto_zoom_y = 0;
	int auto_zoom_z = 0;
	int trigger_hi_x = 0;
	int trigger_hi_y = 0;
	int trigger_hi_z = 0;
	int trigger_lo_x = 0;
	int trigger_lo_y = 0;
	int trigger_lo_z = 1;
	int set_hi_x = 0;
	int set_hi_y = 0;
	int set_hi_z = 0;
	int set_lo_x = 0;
	int set_lo_y = 0;
	int set_lo_z = 0;
	int proximity_x = 0;
	int proximity_y = 0;
	int proximity_z = 0;
	int proximity_mode_x = 0;
	int proximity_mode_y = 0;
	int proximity_mode_z = 0;
	int segments_x = 16;
	int segments_y = 16;
	int segments_z = 0;
	int tag_mode = 0;
	int format_id = 0;
	int table_id = 0;
	int record_id = id;
	int size = 420;
	
	if((foutptr = fopen("usr/csv/antz0001node.csv", "w")) == NULL) { 	
		printf("Cannot open output file\n"); 		
	} 						

	if((ftagptr = fopen("usr/csv/antz0001tag.csv", "w")) == NULL) { 	
		printf("Cannot open tag file\n"); 		
	} 						

	fprintf(ftagptr, "id,record_id,table_id,title,description\n");

	//Output initial lines of ANTz code for world, cameras, and grid(s)
	fprintf(foutptr, "id,type,data,selected,parent_id,branch_level,child_id,child_index,child_count,ch_input_id,ch_output_id,ch_last_updated,average,interval,aux_a_x,aux_a_y,aux_a_z,aux_b_x,aux_b_y,aux_b_z,color_shift,rotate_vec_x,rotate_vec_y,rotate_vec_z,rotate_vec_s,scale_x,scale_y,scale_z,translate_x,translate_y,translate_z,tag_offset_x,tag_offset_y,tag_offset_z,rotate_rate_x,rotate_rate_y,rotate_rate_z,rotate_x,rotate_y,rotate_z,scale_rate_x,scale_rate_y,scale_rate_z,translate_rate_x,translate_rate_y,translate_rate_z,translate_vec_x,translate_vec_y,translate_vec_z,shader,geometry,line_width,point_size,ratio,color_index,color_r,color_g,color_b,color_a,color_fade,texture_id,hide,freeze,topo,facet,auto_zoom_x,auto_zoom_y,auto_zoom_z,trigger_hi_x,trigger_hi_y,trigger_hi_z,trigger_lo_x,trigger_lo_y,trigger_lo_z,set_hi_x,set_hi_y,set_hi_z,set_lo_x,set_lo_y,set_lo_z,proximity_x,proximity_y,proximity_z,proximity_mode_x,proximity_mode_y,proximity_mode_z,segments_x,segments_y,segments_z,tag_mode,format_id,table_id,record_id,size\n");
	fprintf(foutptr, "1,0,1,0,0,0,1,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,1,1,1,1,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
	fprintf(foutptr, "2,1,2,0,0,0,2,2,3,0,0,0,0,1,0,0,0,0,0,0,0,0,0.008645,0.825266,-0.564678,1,1,1,-32.446629,-180.908295,143.514175,0,0,1,0,0,0,55.620094,0.600200,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,214.306686,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
	fprintf(foutptr, "3,1,3,0,2,1,3,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,-1,1,1,1,-0.5,0,571.750000,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
	fprintf(foutptr, "4,1,4,0,2,1,4,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,1,-0,1,1,1,0,-90,7,0,0,1,0,0,0,90,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
	fprintf(foutptr, "5,1,5,0,2,1,5,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,-1,-0,-0,1,1,1,85,0,7,0,0,1,0,0,0,90,270,0,0,0,0,0,0,0,-0,0,0,0,0,1,0,0.1,0,50,101,101,255,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,16,16,0,0,0,0,0,420\n");
	fprintf(foutptr, "6,6,6,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,1.0,0.0,0.1,3,0,0,255,150,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0,0,0,12,6,0,0,0,0,0,420\n");
	
	int numlevel0toroids = 10;
	int numlevel1toroids = 1;
	int numlevel2toroids = 10;
	int numlevel3toroids = 0;

	id = 6;
	int taginc = 0;

	// Loop through Branch Level 0 (BL0) objects
	for (i = 0; i < numlevel0toroids; i++) {
		id++;
		parent_id_array[i] = id; // Save the id to be used for Links Loop below
		type = 5;
		data = id;
		parent_id = 0;
		branch_level = 0;
		child_id = id;
		child_count = numlevel1toroids;
		translate_x = rand() % 100;
		translate_y = rand() % 100;
		translate_z = rand() % 100;
		scale_x = 1.0;
		scale_y = scale_x;
		scale_z = scale_x;
		color_index = 17;
		geometry = 11;
		topo = 5;  // A topo of 5 is the usual default for BL 0
		record_id = id;
		fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r_array[i],color_g_array[i],color_b_array[i], color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
		fprintf(ftagptr, "%d,%d,0,\"BL0 id:%d\",\"\"\n", taginc,record_id,id);
		taginc++;
		level0objectid = id; // used for parent_id of child objects

		// Loop through BL1 objects
		for (j = 0; j < numlevel1toroids; j++) {
			id++;
			type = 5;
			data = id;
			parent_id = level0objectid;
			branch_level = 1;
			child_id = id;
			child_count = numlevel2toroids;
			translate_x = -180;
			translate_y = 0;
			translate_z = 0;
			scale_x = 1.0;
			scale_y = scale_x;
			scale_z = scale_x;
			color_index = 17;
			geometry = 7;
			topo = 3;  // A topo of 5 is the usual default for BL 0
			record_id = id;
			fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r_array[i],color_g_array[i],color_b_array[i], color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
			fprintf(ftagptr, "%d,%d,0,\"BL1 id:%d\",\"\"\n", taginc,record_id,id);
			taginc++;
			level1objectid = id; // used for parent_id of child objects

			for (k = 0; k < numlevel2toroids; k++) {
				id++;
				type = 5;
				data = id;
				parent_id = level1objectid;
				branch_level = 2;
				child_id = id;
				child_count = numlevel3toroids;
				translate_x = k*360/numlevel2toroids;
				translate_y = 0;
				translate_z = 180;
				scale_x = 1.0;
				scale_y = scale_x;
				scale_z = scale_x;
				color_index = 17;
				geometry = 7;
				topo = 3;  // A topo of 5 is the usual default for BL 0
				record_id = id;
				fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r_array[i],color_g_array[i],color_b_array[i], color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
				fprintf(ftagptr, "%d,%d,0,\"BL2 id:%d\",\"\"\n", taginc,record_id,id);
				taginc++;
			} // end for k
		} // end for j
	} // end for i

	//////////////////////////////////////////////////////////////////////////
	// Links Loop
	// We loop through total objects twice and create links between each pair
	// We do not allow duplicate links, or links with an object and itself
	//////////////////////////////////////////////////////////////////////////
	for (i = 0; i < numlevel0toroids; i++) {
		for (j = i; j < numlevel0toroids; j++) { // j starts with i to avoid duplicate links
			if (i != j) { // do not link an object with itself
				id++;
				type = 7;
				data = id;
				parent_id = parent_id_array[i];
				branch_level = 1;
				child_id = parent_id_array[j];
				child_count = 0;
				translate_x = 0;
				translate_y = 0;
				translate_z = 0;
				scale_x = 1;
				scale_y = scale_x;
				scale_z = scale_x;
				rotate_x = 0;
				rotate_y = 0;
				rotate_z = 0;
				color_index = 0;
				geometry = 19;
				topo = 0; 
				ratio = 0.25;
				record_id = id;
				fprintf(foutptr, "%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%f,%d,%d,%d,%d,%f,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d,%d\n",id, type, data, selected, parent_id, branch_level, child_id, child_index, child_count, ch_input_id, ch_output_id, ch_last_updated, average, interval, aux_a_x, aux_a_y, aux_a_z, aux_b_x, aux_b_y, aux_b_z, color_shift, rotate_vec_x, rotate_vec_y, rotate_vec_z, rotate_vec_s, scale_x, scale_y, scale_z, translate_x, translate_y, translate_z, tag_offset_x, tag_offset_y, tag_offset_z, rotate_rate_x, rotate_rate_y, rotate_rate_z, rotate_x, rotate_y, rotate_z, scale_rate_x, scale_rate_y, scale_rate_z, translate_rate_x, translate_rate_y, translate_rate_z, translate_vec_x, translate_vec_y, translate_vec_z, shader, geometry, line_width, point_size, ratio, color_index, color_r_array[i],color_g_array[i],color_b_array[i], color_a, color_fade, texture_id, hide, freeze, topo, facet, auto_zoom_x, auto_zoom_y, auto_zoom_z, trigger_hi_x, trigger_hi_y, trigger_hi_z, trigger_lo_x, trigger_lo_y, trigger_lo_z, set_hi_x, set_hi_y, set_hi_z, set_lo_x, set_lo_y, set_lo_z, proximity_x, proximity_y, proximity_z, proximity_mode_x, proximity_mode_y, proximity_mode_z, segments_x, segments_y, segments_z, tag_mode, format_id, table_id, record_id, size);
				fprintf(ftagptr, "%d,%d,0,\"Link id:%d\",\"\"\n", taginc,record_id,id);
				taginc++;
			}
		}
	}


	
	fclose(foutptr);
	fclose(ftagptr);

	return 0;

}
